#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <malloc.h>
#include <string.h>

/**********************************************************************
	 FIREKIT v1.0
			 by

John W. Ractliff
70253.3237@compuserve.com
jratclif@inlink.com

32bit DOS4GW application.
Will run in Microsoft Windowss 32 bit mode.
Source code in ANSI C and Turbo Assembler

The enclosed software was written by John W. Ratcliff on May 27, 1996.
As of this date I am releasing this software into the public domain.

I am releasing this software into the public domain, hopefully, to make
a point.  I would like to demonstrate how to write source code that is
useful to other people.  I was looking at some of the various flame
algorithms and source code examples and in each case they were such hard
coded demos nobody could actually get them integrated into an
application.
************************************************************************/

#include "flames.h"

int  CreateFlame(FLAMESPEC *f,long wid,long hit);
void DestroyFlame(FLAMESPEC *f);
char * LoadPicture(char *fname,char *imagepal);
void FlameColorMatch(FLAMESPEC *f,unsigned char *imagepal,unsigned char *fpal);

// Different fuel feeder mask sizes.
static int masktable[10] = { 0, 1, 3, 7, 15, 31, 63, 127, 255, 511 };

void main(void)
{
	int key,xcon=0;
	FLAMESPEC f;
	int fheight=80; // initial flame height.
	int fwidth=320;  // initial flame width.
	int fuel;
	int mask=5;
	char *picimage=0;
	char *buildframe=0;
	unsigned char imagepal[768]; // palette for the image.
	unsigned char fpal[768];

	buildframe = malloc(64000); // holds scratch image buffer for background pic demo.
	CreateFlame(&f,fwidth,fheight); // create flame buffers of this size.
	fuel = f.fuel; // initial fuel equal to default fuel.

	FlameStart(); // turn 320x200 256 color graphics mode on DOS only!
	FlamePal(fpal); // set the flame color palette, and return 8 bit rgb values in fpal

	do
	{
		// Change fuel amount if change is requested.
		if ( f.fuel != fuel )
		{
			if ( f.fuel < fuel ) f.fuel++;
			if ( f.fuel > fuel ) f.fuel--;
		}

		FlameFrame(&f); // compute the flame frame.

		if ( picimage ) // if demonstrating merge with application screen.
		{
			memcpy(buildframe,picimage,64000); // copy demo app image into buildframe
			FlameCopyTranslate(&f,buildframe); // copy translate flames into application memory
			FlameImage(buildframe); // copy entire image DOS only routine.
		}
		else
			FlameCopy(&f);	// Copy the flame to the video screen, DOS ONLY!

		if ( kbhit() )
		{
			key = getch();
			switch ( key )
			{
				case 'a':
				case 'A':
					f.fheight = 0;
					break;
				case 'b':
				case 'B':
					f.fheight = 1;
					break;
				case 'c':
				case 'C':
					f.fheight = 2;
					break;
				case 'd':
				case 'D':
					f.fheight = 3;
					break;
				case 'p':
				case 'P':
					if ( picimage )
					{
						free(picimage);
						picimage = 0;
						FlameZeroScreen();
						FlamePal(fpal);
					}
					else
					{
						picimage = LoadPicture("image",imagepal);
						if ( picimage )
						{
							FlameDAC(imagepal);
							FlameColorMatch(&f,imagepal,fpal);
						}
					}
					break;
				case 'y':
					fheight+=20;
					if ( fheight > 200 ) fheight = 200;
					if ( fheight != f.height )
					{
						DestroyFlame(&f); // free frame buffers
						CreateFlame(&f,fwidth,fheight); // create new flame buffer
						FlameZeroScreen();
					}
					break;
				case 'Y':
					fheight-=20;
					if ( fheight < 20 ) fheight = 20;
					if ( fheight != f.height )
					{
						DestroyFlame(&f);
						CreateFlame(&f,fwidth,fheight);
						FlameZeroScreen();
					}
					break;

				case 'x':
					fwidth+=20;
					if ( fwidth > 320 ) fwidth = 320;

					if ( fwidth != f.width )
					{
						DestroyFlame(&f); // free frame buffers
						CreateFlame(&f,fwidth,fheight); // create new flame buffer
						FlameZeroScreen();
					}

					break;
				case 'X':
					fwidth-=20;
					if ( fwidth < 20 ) fwidth = 20;
					if ( fwidth != f.width )
					{
						DestroyFlame(&f);
						CreateFlame(&f,fwidth,fheight);
						FlameZeroScreen();
					}
					break;

				case 'f':
				case 'F':
					f.fire8 = 1-f.fire8;
					break;
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					f.fuelbase = (key-'0')*12;
					break;
				case '+':
					fuel = f.fuel+20;
					if ( fuel > 255 ) fuel = 255;
					break;
				case '-':
					fuel = f.fuel-20;
					if ( fuel < 0 ) fuel = 0;
					break;
				case ']':
					mask++;
					if ( mask > 9 ) mask = 9;
					f.andmask = masktable[mask];
					break;
				case '[':
					mask--;
					if ( mask < 0 ) mask = 0;
					f.andmask = masktable[mask];
					break;
				case 27:
					xcon = 1;
					break;
			}
		}
	} while ( !xcon );

	DestroyFlame(&f);
	free(buildframe);
	if ( picimage ) free(picimage);

	FlameStop();

}

// create a flame buffer.
int CreateFlame(FLAMESPEC *f,long wid,long hit)
{
	int i,j;

	f->width = wid;
	f->height = hit;
	f->fsize = wid*hit;
	f->fheight = 1;
	f->fuel = 100+hit;
	if ( f->fuel > 255 ) f->fuel = 255;
	f->fire8 = 0;
	f->ScreenX = (320-wid)/2; // center on screen
	f->ScreenY = 200-hit; // put on bottom.
	f->jitter = malloc(sizeof(long)*512);
	if ( !f->jitter ) return(0);

	// make the 512 entry random jitter table.
	for (i=0; i<512; i++)
	{
		j = rand()%f->width; // assign valid random jitter value.
		if ( j < 1 ) j = 1;
		if ( j > (f->width-2) ) j = (f->width-2);
		f->jitter[i] = j;
	}

	f->seed = 0;
	f->andmask = 0x31;
	f->fuelbase = 64;

	f->flame1 = malloc(f->fsize);
	if ( !f->flame1 )
	{
		free(f->jitter);
		return(0);
	}
	f->flame2 = malloc(f->fsize);
	if ( !f->flame2 )
	{
		free(f->flame1);
		free(f->jitter);
		return(0);
	}
	memset(f->flame1,0,f->fsize);
	memset(f->flame2,0,f->fsize);

	return(1);
}

void DestroyFlame(FLAMESPEC *f)
{
	if ( f->flame1 ) free(f->flame1);
	if ( f->flame2 ) free(f->flame2);
	if ( f->jitter ) free(f->jitter);
	f->flame1 = f->flame2 = 0;
}

char * LoadPicture(char *fname,char *imagepal)
{
	FILE *fph;
	char name[256];
	char *image;

	strcpy(name,fname);
	strcat(name,".PAK");
	fph = fopen(name, "rb");
	if ( fph )
	{
		image = malloc(64000);
		if ( !image ) return(0);
		fread(image, 64000, 1, fph);
		fclose(fph);
		strcpy(name,fname);
		strcat(name,".PAL");
		fph = fopen(name, "rb");
		if ( fph )
		{
			fread(imagepal, 768, 1, fph);
			fclose(fph);
			return(image);
		}
		free(image);
		return(0);
	}
	return(0);
}

void FlameColorMatch(FLAMESPEC *f,unsigned char *imagepal,unsigned char *fpal)
{
	long i,red,green,blue,j;

	for (i=0; i<256; i++)
	{
		red = fpal[i*3];
		green = fpal[i*3+1];
		blue = fpal[i*3+2];
		j = FlameClosestColor(imagepal,red,green,blue);
		f->ctrans[i] = j; // color translate.
	}
}
